(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    209307,       4107]
NotebookOptionsPosition[    206709,       4055]
NotebookOutlinePosition[    207128,       4072]
CellTagsIndexPosition[    207085,       4069]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Rectangles - arbitrary point", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, 
   3.947147906503248*^9, {3.947481336744753*^9, 3.947481338032559*^9}, {
   3.947482272199051*^9, 3.947482274311268*^9}, {3.954750595159647*^9, 
   3.954750601824375*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about rectangles in the \
paper \[OpenCurlyDoubleQuote]More Shapes of Central Quadrilaterals\
\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in July \
2025.

This Notebook is Copyright \[Copyright] July 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947481344697075*^9, 3.947481347432724*^9}, {
  3.947482281782265*^9, 3.947482284055073*^9}, {3.9547492905573807`*^9, 
  3.954749346503187*^9}, {3.961411396251758*^9, 
  3.96141140479523*^9}},ExpressionUUID->"08758b0a-705f-b842-b1d6-\
6a28a79b6218"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"5e4c6aa2-710c-4599-941e-\
5f13e499af78"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptD", "=", 
   RowBox[{"SimetriaCentral", "[", 
    RowBox[{"ptB", ",", 
     RowBox[{"Medio", "[", 
      RowBox[{"ptA", ",", "ptC"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rectangle", "=", 
   RowBox[{
    SuperscriptBox["b", "2"], "==", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["c", "2"]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.947481378154803*^9, 3.947481389864706*^9}, {3.9546600316839104`*^9, 
   3.954660069833351*^9}},
 CellLabel->
  "In[634]:=",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"cf60f297-bbcd-8748-b453-\
e7118b4e0a98"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "central", " ", "quadrilateral", " ", "of", " ", "ABCD", " ", "wrt", " ", 
     "a", " ", "point", " ", "E"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"n_Integer", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{
           RowBox[{"ETC", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", "#"}], "]"}], "]"}], 
        "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"ptX_", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"ptX", ",", "#"}], "]"}], "]"}], "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "tests", " ", "for", " ", "parallelism", " ", "and", " ", 
     "perpendicularity"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"parallelQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinito", "[", "r", "]"}], ".", "s"}], "]"}], "/.", 
         "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"perpendicularQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinitoPerpendicular", "[", 
            RowBox[{"PuntoInfinito", "[", "r", "]"}], "]"}], ".", "s"}], 
          "]"}], "/.", "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"test", " ", "for", " ", "orthodiagonal", " ", "quad"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ortodiagonalQuadQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{"perpendicularQ", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P", ",", "R"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q", ",", "S"}], "]"}], ",", "cond"}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.947132996916015*^9, 3.9471330125156*^9}, {
   3.947133479684403*^9, 3.947133480044634*^9}, {3.954749394336471*^9, 
   3.954749396294033*^9}, {3.954750090329485*^9, 3.954750131865982*^9}, {
   3.954753612330324*^9, 3.954753613564296*^9}, 3.954753651040304*^9, {
   3.954753717466011*^9, 3.9547537696116104`*^9}, 3.954753823286117*^9, {
   3.9547539533955135`*^9, 3.954754007724783*^9}, {3.961111239931719*^9, 
   3.961111240618471*^9}, 3.961413798794177*^9},
 CellLabel->
  "In[638]:=",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"14945f58-5985-ed42-b85a-\
4d36e2d886cd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQs81Nn/Pz7jr9Ij1Y/d+rC1ulht68vW0mVd+kTKrdw2Q8k1yjV26OJW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    "], {{0, 258.79245283018867`}, {503.99999999999994`, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{503.99999999999994`, 258.79245283018867`},
  PlotRange->{{0, 503.99999999999994`}, {0, 258.79245283018867`}}]], "Text",
 CellChangeTimes->{3.954748652040457*^9, 3.957151387176321*^9, 
  3.95715149207003*^9},ExpressionUUID->"9d937e05-6d29-7d42-9eff-f268029c5aa8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ptE", "=", 
    RowBox[{"{", 
     RowBox[{"u", ",", "v", ",", "w"}], "}"}]}], ";"}], "  ", 
  RowBox[{"(*", 
   RowBox[{
   "arbitrary", " ", "point", " ", "in", " ", "the", " ", "plane", " ", "of", 
    " ", "ABCD"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.954749532942322*^9, 3.954749537988825*^9}, {
   3.954749857929596*^9, 3.954749858260048*^9}, {3.954750023038857*^9, 
   3.95475002381987*^9}, 3.954750167904394*^9, 3.9547536082621517`*^9, {
   3.954753779465971*^9, 3.954753780080479*^9}, {3.954754016659415*^9, 
   3.954754029729986*^9}},
 CellLabel->
  "In[647]:=",ExpressionUUID->"3f2dd6a3-e827-a14e-8287-9a6e9355626c"],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnT9oI8u355tdLyhU8AIFE4xgAgsmGIGDEdxkBDcYwQTW2wlGi4N5Wu/j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    "], {{0, 92.37735849056604}, {955.6981132075471, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{955.6981132075471, 92.37735849056604},
  PlotRange->{{0, 955.6981132075471}, {0, 92.37735849056604}}]], "Input",
 Evaluatable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"749e61ed-ad37-1843-819d-2f16380c9f91"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnT9oI8u355tdLyhU8AIFE4xgAgsmGIGDEdxkBDcYwQTW2wlGi4N5Wu/j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    "], {{0, 92.37735849056604}, {955.6981132075471, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{955.6981132075471, 92.37735849056604},
  PlotRange->{{0, 955.6981132075471}, {0, 92.37735849056604}}]], "Output",
 CellChangeTimes->{3.961411426879067*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"1ea7db03-05d0-47ba-8639-9426ea618bdb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "triangle", " ", "center", " ", "on", " ", "the", " ", "Euler", " ", 
    "line", " ", "with", " ", "constant", " ", "Shinagawa", " ", 
    "coefficients"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"ptX", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"Evaluar", "[", 
     RowBox[{"TernaCiclica", "[", 
      RowBox[{
       RowBox[{"m", " ", 
        SuperscriptBox["S", "2"]}], "+", 
       RowBox[{"n", " ", "SB", " ", "SC"}]}], "]"}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.957148700613481*^9, 3.9571487269127464`*^9}, {
  3.957148875451629*^9, 3.9571488755371094`*^9}, {3.9571512107342873`*^9, 
  3.957151228820423*^9}, {3.9611113864050617`*^9, 3.9611114326233006`*^9}},
 CellLabel->
  "In[648]:=",ExpressionUUID->"d049469c-4102-7346-8c12-3f152a373a91"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}], " ", "m"}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "m"}], "+", "n"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n"}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "m"}], "+", 
    RowBox[{
     SuperscriptBox["b", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "m"}], "+", "n"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["c", "4"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n"}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["b", "2"], " ", "m"}], "+", 
       RowBox[{
        SuperscriptBox["c", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "4"]}], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n"}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["c", "2"], " ", "m"}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["c", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "m"}], "+", "n"}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}]}]}], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9571487285392303`*^9, 3.957148776798092*^9, 3.9571488766749787`*^9, 
   3.957151134275734*^9, {3.957151220557228*^9, 3.957151230191658*^9}, 
   3.9611114388214607`*^9, 3.96141142692559*^9, 3.9614138370194473`*^9},
 CellLabel->
  "Out[648]=",ExpressionUUID->"d57ce72d-606d-4b7c-8e03-5457ea56d97d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"centralQuadrilateral", "[", 
   RowBox[{"ptX", ",", "ptE"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.957148780513574*^9, 3.957148781553039*^9}, {
   3.9571492800904274`*^9, 3.957149319113586*^9}, {3.957149421420681*^9, 
   3.957149433153187*^9}, 3.957151250251227*^9},
 CellLabel->
  "In[649]:=",ExpressionUUID->"d33ce7fd-d208-cd46-a39f-eb8804b46567"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", "w", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"v", "-", "w"}], ")"}]}], "+", 
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "u"}], "+", "v", "+", "w"}], ")"}]}]}], ")"}]}],
       "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "w", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}]}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "u"}], "+", "v", "+", "w"}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "u"}], "+", "w"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}]}], "+", 
            RowBox[{"m", " ", "w", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "u"}], "+", "v", "+", "w"}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "w", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", "v"}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "u"}], "+", "v", "+", "w"}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", " ", "w", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "u"}], "+", "v", "+", "w"}], ")"}]}], "-", 
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"u", " ", "v"}], "-", 
               RowBox[{"u", " ", "w"}], "+", 
               RowBox[{"v", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "4"]}], " ", "w", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"u", "-", "w"}], ")"}]}], "+", 
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", 
            RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "w", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "w"}], ")"}]}], "+", 
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", 
            RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", " ", "v", " ", "w"}], "-", 
         RowBox[{"n", " ", "u", " ", 
          RowBox[{"(", 
           RowBox[{"v", "+", "w"}], ")"}]}], "+", 
         RowBox[{"m", " ", "w", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", 
            RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "w"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}], "+", 
         RowBox[{"m", " ", "w", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", 
            RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "w", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", "u"}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "w"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}]}], "+", 
            RowBox[{"m", " ", "w", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}], "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n"}], ")"}], " ", 
       SuperscriptBox["w", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "m"}], " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "u"}], "+", "w"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "2"], " ", "w", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"u", "-", "v"}], ")"}]}], "+", 
            RowBox[{"m", " ", "w"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "u"}], "+", "v"}], ")"}]}], "+", 
            RowBox[{"m", " ", "w"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n"}], ")"}], " ", 
       SuperscriptBox["u", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "m"}], " ", 
          SuperscriptBox["u", "2"]}], "+", 
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", 
            RowBox[{"2", " ", "v"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", 
            RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", "u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", " ", "u"}], "+", 
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"v", "-", "w"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", " ", "u"}], "+", 
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "v"}], "+", "w"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", 
            RowBox[{"2", " ", "v"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "w"}], ")"}]}], "+", 
         RowBox[{"m", " ", "u", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", 
            RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "u"}], "+", "w"}], ")"}]}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "w"}], ")"}]}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", "u", " ", 
             RowBox[{"(", 
              RowBox[{"v", "-", "w"}], ")"}]}], "-", 
            RowBox[{"n", " ", "v", " ", "w"}], "+", 
            RowBox[{"m", " ", "u", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "w"}], ")"}]}], "+", 
            RowBox[{"m", " ", "u", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "v"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", 
            RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
         RowBox[{"m", " ", "u", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "v", "+", 
            RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "u"}], "+", "v"}], ")"}]}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v", "+", 
               RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v"}], ")"}]}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v", "+", 
               RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "w"}], ")"}]}], "+", 
            RowBox[{"m", " ", "u", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v", "+", 
               RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", " ", "u", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v", "+", 
               RowBox[{"2", " ", "w"}]}], ")"}]}], "-", 
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"u", " ", "v"}], "-", 
               RowBox[{"u", " ", "w"}], "+", 
               RowBox[{"v", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{"u", "+", "v"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "u"}], "+", "v", "+", "w"}], ")"}]}], "+", 
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "u"}], "+", 
            RowBox[{"3", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "v"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}]}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "u"}], "+", "v", "+", "w"}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "n"}], " ", 
             RowBox[{"(", 
              RowBox[{"u", "-", "v"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}]}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "u"}], "+", "v", "+", "w"}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "v"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "u"}], "+", "v", "+", "w"}], ")"}]}], "+", 
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "u"}], "+", "v", "+", "w"}], ")"}]}], "+", 
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["u", "2"], "-", 
               RowBox[{"v", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"u", "+", "v"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "u"}], "+", "w"}], ")"}]}], "+", 
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "w"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"u", "+", "v"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "w"}], ")"}]}], "+", 
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", 
            RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "v"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "w"}], ")"}]}], "+", 
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"u", "-", "v"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", 
            RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "v"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "w"}], ")"}]}], "-", 
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["v", "2"], "+", 
            RowBox[{"u", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "v"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "w"}], ")"}]}], "+", 
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "w"}], ")"}]}], "+", 
            RowBox[{"n", " ", "u", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"u", "+", "v"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"u", "-", "v"}], ")"}]}], "+", 
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "u"}], "+", 
            RowBox[{"2", " ", "v"}], "+", 
            RowBox[{"3", " ", "w"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"u", "+", "v"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", " ", "w"}], "+", 
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "u"}], "+", 
            RowBox[{"2", " ", "v"}], "+", 
            RowBox[{"3", " ", "w"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"u", "+", "v"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", " ", "w"}], "+", 
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "u"}], "+", 
            RowBox[{"2", " ", "v"}], "+", 
            RowBox[{"3", " ", "w"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"u", "+", "v"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", "w"}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "u"}], "+", 
               RowBox[{"2", " ", "v"}], "+", 
               RowBox[{"3", " ", "w"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"3", " ", "v"}], "+", 
               RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "u"}], "+", 
               RowBox[{"2", " ", "v"}], "+", 
               RowBox[{"3", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "v"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "u"}], "+", 
            RowBox[{"2", " ", "v"}], "+", 
            RowBox[{"3", " ", "w"}]}], ")"}]}], "+", 
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["u", "2"]}], "-", 
            RowBox[{"v", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}], "+", 
            RowBox[{"u", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "v"}], "+", 
               RowBox[{"3", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{"v", "+", "w"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "m", " ", "u"}], "+", 
         RowBox[{"n", " ", "u"}], "+", 
         RowBox[{"2", " ", "m", " ", 
          RowBox[{"(", 
           RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "u"}], " ", "v"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["v", "2"]}], "+", 
            RowBox[{"3", " ", "u", " ", "w"}], "+", 
            RowBox[{"4", " ", "v", " ", "w"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{"v", "+", "w"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "u"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"v", "+", "w"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "m", " ", "u"}], "+", 
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "v"}], "+", "w"}], ")"}]}], "+", 
            RowBox[{"2", " ", "m", " ", 
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "m", " ", "u"}], "+", 
            RowBox[{"2", " ", "m", " ", 
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}]}], "+", 
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "u"}], "+", 
               RowBox[{"3", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "w"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"v", "+", "w"}], ")"}]}], "-", 
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"v", "-", "w"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", 
            RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"v", "+", "w"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"u", "-", "w"}], ")"}]}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "w"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "w"}], ")"}]}], "+", 
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "w"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}]}], "+", 
            RowBox[{"n", " ", "w", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "w"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}]}], "-", 
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["v", "2"], "+", 
               RowBox[{"u", " ", "w"}], "+", 
               RowBox[{"2", " ", "v", " ", "w"}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "v"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"v", "-", "w"}], ")"}]}], "+", 
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{"v", "+", "w"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "v", "+", 
            RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"v", "+", "w"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v"}], ")"}]}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v", "+", 
               RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v", "+", 
               RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"3", " ", "v"}], "+", 
               RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", "v", " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v"}], ")"}]}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v", "+", 
               RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"u", "+", "v", "+", 
               RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
            RowBox[{"n", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "u"}], " ", "v"}], "-", 
               RowBox[{"2", " ", 
                SuperscriptBox["v", "2"]}], "+", 
               SuperscriptBox["w", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.957148790448284*^9, 3.957148880765041*^9, 
  3.9571492893169155`*^9, 3.9571493219289913`*^9, 3.957149435127718*^9, 
  3.9571511351797333`*^9, 3.957151252177189*^9, 3.961111453521103*^9, 
  3.9614114278901253`*^9, 3.961413837867506*^9},
 CellLabel->
  "Out[649]=",ExpressionUUID->"23737ae9-0277-49f8-b92b-f292d87d2ba1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ortodiagonalQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "rectangle"}], "]"}]], "Input",
 CellLabel->
  "In[650]:=",ExpressionUUID->"c76d06db-042b-384d-b486-6eb3a37b5ceb"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9571511369926815`*^9, 3.9571512604300547`*^9, 
  3.9611114655721703`*^9, 3.961411429638035*^9, 3.9614138394100313`*^9},
 CellLabel->
  "Out[650]=",ExpressionUUID->"c6643d4b-c6c5-4c40-9338-486e475e516d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptF", ",", "ptH"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptB", ",", "ptC"}], "]"}], ",", "rectangle"}], "]"}]], "Input",
 CellChangeTimes->{
  3.9571494602105637`*^9, {3.95715112369376*^9, 3.957151149634657*^9}, {
   3.9611115184060974`*^9, 3.9611115202218323`*^9}},
 CellLabel->
  "In[651]:=",ExpressionUUID->"fd82e13d-9fd6-e04a-adbb-bd7cce102a94"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.957148857892636*^9, 3.9571489283627243`*^9, 3.9571493409037933`*^9, {
   3.9571494428346825`*^9, 3.9571494624446983`*^9}, {3.957151145429308*^9, 
   3.9571511510687275`*^9}, 3.957151269797129*^9, 3.9611115214983654`*^9, 
   3.961411429792572*^9, 3.961413839770863*^9},
 CellLabel->
  "Out[651]=",ExpressionUUID->"0a9fab96-73d7-48c5-a4cd-17980e897bbc"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptG", ",", "ptI"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptA", ",", "ptB"}], "]"}], ",", "rectangle"}], "]"}]], "Input",
 CellLabel->
  "In[652]:=",ExpressionUUID->"f91118da-a20b-304f-a7f3-1e66c740f4d5"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.957148857892636*^9, 3.9571489283627243`*^9, 3.9571493409037933`*^9, {
   3.9571494428346825`*^9, 3.9571494624446983`*^9}, {3.957151145429308*^9, 
   3.9571511510687275`*^9}, 3.957151269926123*^9, 3.9611115240455513`*^9, 
   3.961411429853953*^9, 3.96141383992516*^9},
 CellLabel->
  "Out[652]=",ExpressionUUID->"047e1952-c535-4b26-9d1b-2d61d929e660"]
},
CellGrouping->Manual,
WindowSize->{1345, 1054},
WindowMargins->{{205, Automatic}, {Automatic, 28}},
FrontEndVersion->"14.2 for Mac OS X x86 (64-bit) (March 16, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"be3740c5-6cf4-6e44-a959-8ed4dbb0b0da"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 340, 5, 96, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[901, 27, 1461, 25, 164, "Text",ExpressionUUID->"08758b0a-705f-b842-b1d6-6a28a79b6218"],
Cell[CellGroupData[{
Cell[2387, 56, 200, 4, 66, "Section",ExpressionUUID->"5e4c6aa2-710c-4599-941e-5f13e499af78"],
Cell[2590, 62, 1690, 40, 90, "Input",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"]
}, Closed]],
Cell[CellGroupData[{
Cell[4317, 107, 255, 4, 52, "Section",ExpressionUUID->"cf60f297-bbcd-8748-b453-e7118b4e0a98"],
Cell[4575, 113, 6658, 183, 381, "Input",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],
Cell[CellGroupData[{
Cell[11270, 301, 211, 4, 52, "Section",ExpressionUUID->"14945f58-5985-ed42-b85a-4d36e2d886cd"],
Cell[11484, 307, 105559, 1734, 273, "Text",ExpressionUUID->"9d937e05-6d29-7d42-9eff-f268029c5aa8"],
Cell[117046, 2043, 680, 16, 29, "Input",ExpressionUUID->"3f2dd6a3-e827-a14e-8287-9a6e9355626c"],
Cell[CellGroupData[{
Cell[117751, 2063, 25741, 426, 105, "Input",ExpressionUUID->"749e61ed-ad37-1843-819d-2f16380c9f91",
 Evaluatable->False],
Cell[143495, 2491, 25706, 424, 109, "Output",ExpressionUUID->"1ea7db03-05d0-47ba-8639-9426ea618bdb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[169238, 2920, 836, 20, 51, "Input",ExpressionUUID->"d049469c-4102-7346-8c12-3f152a373a91"],
Cell[170077, 2942, 2650, 87, 57, "Output",ExpressionUUID->"d57ce72d-606d-4b7c-8e03-5457ea56d97d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[172764, 3034, 472, 10, 29, "Input",ExpressionUUID->"d33ce7fd-d208-cd46-a39f-eb8804b46567"],
Cell[173239, 3046, 31257, 943, 419, "Output",ExpressionUUID->"23737ae9-0277-49f8-b92b-f292d87d2ba1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[204533, 3994, 265, 7, 29, "Input",ExpressionUUID->"c76d06db-042b-384d-b486-6eb3a37b5ceb"],
Cell[204801, 4003, 255, 4, 33, "Output",ExpressionUUID->"c6643d4b-c6c5-4c40-9338-486e475e516d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[205093, 4012, 456, 11, 29, "Input",ExpressionUUID->"fd82e13d-9fd6-e04a-adbb-bd7cce102a94"],
Cell[205552, 4025, 407, 7, 33, "Output",ExpressionUUID->"0a9fab96-73d7-48c5-a4cd-17980e897bbc"]
}, Open  ]]
}, Open  ]],
Cell[205986, 4036, 310, 8, 29, "Input",ExpressionUUID->"f91118da-a20b-304f-a7f3-1e66c740f4d5"],
Cell[206299, 4046, 406, 7, 33, "Output",ExpressionUUID->"047e1952-c535-4b26-9d1b-2d61d929e660"]
}
]
*)

